import java.util.Scanner;

public class Main {
    public static void main(String[] args) {

        Scanner in = new Scanner(System.in);
        int n = in.nextInt();

        long[] x = new long[n];
        long[] y = new long[n];

        for (int i = 0; i < n; i++) {
            x[i] = in.nextLong();
            y[i] = in.nextLong();
        }

        int[] idx = new int[n];
        for (int i = 0; i < n; i++) idx[i] = i;

        long ans = 0;

        Arrays.sort(idx, (a, b) -> {
            long ka = x[a] - y[a];
            long kb = x[b] - y[b];
            if (ka == kb) return Long.compare(x[a], x[b]);
            return Long.compare(ka, kb);
        });

        for (int i = 0; i < n - 1; i++) {
            int p = idx[i];
            int q = idx[i + 1];

            long k1 = x[p] - y[p];
            long k2 = x[q] - y[q];

            if (k1 != k2) continue;

            long dx = x[q] - x[p];
            long dy = y[q] - y[p];

            if (dx * dy < 0) ans++;
        }

        Arrays.sort(idx, (a, b) -> {
            long ka = x[a] + y[a];
            long kb = x[b] + y[b];
            if (ka == kb) return Long.compare(x[a], x[b]);
            return Long.compare(ka, kb);
        });

        for (int i = 0; i < n - 1; i++) {
            int p = idx[i];
            int q = idx[i + 1];

            long k1 = x[p] + y[p];
            long k2 = x[q] + y[q];

            if (k1 != k2) continue;

            long dx = x[q] - x[p];
            long dy = y[q] - y[p];

            if (dx * dy < 0) ans++;
        }

        System.out.println(ans);
    }
}